// C++DLLIntegrationTest.cpp : Defines the entry point for the console application.
//

#import "..\..\build\bin\Release\HuberPBWrapper.tlb"
#include <iostream>
#include <string>

int main()
{
	// Initialize the COM library
	HRESULT hr = CoInitialize(NULL);
	// get a pointer to the HuberPBWrapper interface
	HuberPBWrapper::PBInterfacePtr pbptr(__uuidof(HuberPBWrapper::PB));
	// define the IP address of the Pilot ONE
	std::string str = "192.168.10.155";
	_bstr_t bstr = str.c_str();

	try {
		VARIANT_BOOL bConnected;
		float fValue;
		bConnected = pbptr->bConnect(bstr); //connect to Pilot ONE
		fValue = pbptr->fGetvSP(); //get setpoint in C
		std::cout << "Sollwert: " << fValue << std::endl; //display setpoint in console
		fValue = pbptr->fSetvSP(29.50f); //set setpoint to 29,5 C and get new setpoint
		std::cout << "neuer Sollwert: " << fValue << std::endl; //display new setpoint in console
	}
	catch (_com_error& e) {
		std::cout << "HuberPBWrapper exception: "  << e.Description() << std::endl; 
	}
	catch (...) {
		std::cout << "other expection";
	}

	// COM deinitialisieren
	CoUninitialize();
	return 0;
}
