﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using HuberPBWrapper;

class Program
{
    static void Main(string[] args)
    {
        PB huber = new PB(); //create the HuberPBWrapper interface
        try
        {
            bool connected = huber.bConnect("192.168.10.155"); //connect to Pilot ONE with IP address 192.168.10.155
            Console.WriteLine("Serial number: " + huber.iGetvSNR()); //get setpoint in °C and display it in console
            Console.WriteLine("Actual setpoint: " + huber.fGetvSP() + " °C"); //display setpoint in console
            Console.WriteLine("New setpoint: " + huber.fSetvSP(17.38f) + " °C"); //set setpoint to 17.38 °C and display the new value in console
            Console.WriteLine("Actual return temperature: " + huber.fGetvTR() + " °C"); //get the return temperature in °C and display it in console
        }
        catch (PB.PBException e)
        {
            Console.WriteLine("HuberPBWrapper exception: " + e.Message);
        }
        catch (Exception e) {
            Console.WriteLine(e.Message);
        }
    }
}
